#!/bin/sh
#
# This script installs the unified NVidia driver.  It basically boils down
# to three commands; you could just as easily run them by hand.
#
# Bugs:
#	This script is not terribly robust.  Try not to stress it; 'bash'
#	isn't my first language.
#
# Leo L. Schwab						2000.09.30
#

ask() {
  until
    echo -n "$1"
    if ! read
    then
      echo EOF
      exit 1
    fi
    case $REPLY in 
      y|yes|n|no) true ;;
      *) false;;
    esac
  do
  echo please answer yes or no
  done
  case $REPLY in n|no) return 1 ;; esac
  return 0
}


# This doesn't seem to actually work...
if echo $_ | grep Tracker
then
	# if invoked from tracker
	export INWINDOW=1
	Terminal -t "Unified NVidia Driver Installation" $0
	exit 0
fi

ARCHIVE="./nvidia-2000_09_30.zip"
DRIVERDIR="/system/add-ons/kernel/drivers/bin"
# (only the old rivatnt for now.  riva128 will be added later when it's
# working)
OLDDRIVERS="rivatnt"


echo "Experimental unified NVidia graphics driver"
echo "-------------------------------------------"
echo
echo "This script will install the experimental unified driver for NVidia-based"
echo "graphics cards.  If you have not read the \"NVidia-README\" file, DO SO"
echo "NOW!  The confusion you save may be your own."
echo

if ! ask "Do you wish to install the driver? "
then
	exit 0
fi

if [ ! -e $ARCHIVE ]; then
	echo "I can't find the driver archive $ARCHIVE.  Please 'cd' to the"
	echo "directory where it's located and run this script again."
	exit 1
fi

# Disable old drivers superseded by this one.
#
echo
echo "Disabling obsolete drivers:"
for drv in $OLDDRIVERS; do
	if [ -e $DRIVERDIR/$drv ]; then
		echo "...$drv"
		mv $DRIVERDIR/$drv $DRIVERDIR/$drv-disabled
	fi
done
echo "Done."

echo
echo "Unpacking unified NVidia driver..."
unzip $ARCHIVE -d /

echo
echo "Installation completed!"
echo
echo "Reboot BeOS to use your new drivers."
echo


if [ "$INWINDOW" != "" ]
then
	echo -n "(Press Enter to close this window.) "
	read
fi
